package gov.va.vamf.service.clio.flowsheet.cache;

import java.util.concurrent.*;

/**
 * Singleton used by caches to load items on refresh in the background.
 *
 * @see gov.va.vamf.service.clio.flowsheet.cache.ClioCache
 */
public class BackgroundExecutorService {
    private static ExecutorService executor = Executors.newFixedThreadPool(3);

    /**
     * Stop executor to stop handlers.  Try to let them finish before forcing them to stop.
     *
     * Process taking from Java Executor API docs.
     */
    public static void stop() {
        executor.shutdown();
        try {
            // Wait a while for existing tasks to terminate
            if (!executor.awaitTermination(60, TimeUnit.SECONDS)) {
                executor.shutdownNow();
                // Wait a while for tasks to respond to being cancelled
                //if (!executor.awaitTermination(SHUTDOWN_WAIT_TIME, TimeUnit.SECONDS))
                //     logger.warn("Discharge process bus did not shutdown properly.");
            }
        } catch (InterruptedException ie) {
            //logger.warn("Forcing threads to shutdown.", ie);

            // (Re-)Cancel if current thread also interrupted
            executor.shutdownNow();
            // Preserve interrupt status
            Thread.currentThread().interrupt();
        }
    }

    public static void executeTask(Runnable task) {
        executor.execute(task);
    }
}
