package gov.va.vamf.service.clio.application.server;

import gov.va.vamf.service.clio.application.config.ClioFlowsheetsConfig;
import gov.va.vamf.service.clio.flowsheet.cache.BackgroundExecutorService;
import gov.va.vamf.service.clio.flowsheet.cache.flowsheet.FlowsheetCache;
import gov.va.vamf.service.clio.flowsheet.cache.flowsheet.FlowsheetListCache;
import gov.va.vamf.service.clio.flowsheet.cache.location.LocationsCache;
import gov.va.vamf.service.clio.infrastructure.vista.VistaServiceFactory;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.aeonbits.owner.ConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Add a Description.  Should include class purpose (why not what) and assumptions.
 */
public class ServerContext implements ServletContextListener {
    private static Logger logger = LoggerFactory.getLogger(ServerContext.class);

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        logger.debug("Initializing clio flowsheet service configuration.");
        ClioFlowsheetsConfig config = ConfigFactory.create(ClioFlowsheetsConfig.class, System.getProperties());

        VistaServiceFactory.init(config);

        FlowsheetListCache.init(config);
        FlowsheetCache.init(config);
        LocationsCache.init(config);
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        BackgroundExecutorService.stop();
    }
}
