package gov.va.vamf.service.clio.application.resources;

import gov.va.vamf.service.clio.flowsheet.resources.FlowsheetsResources;
import gov.va.vamf.service.clio.application.representations.Link;
import gov.va.vamf.service.clio.observation.resources.ObservationResources;

import javax.ws.rs.core.*;

/**
 * Generates links used in representations.
 */
public class Routes {
    private final UriInfo info;
    private final String assigningAuthority;

    public Routes(UriInfo info, String assigningAuthority) {
        this.info = info;
        this.assigningAuthority = assigningAuthority;
    }

    public Link getFlowsheetList() {
        return new Link("get-flowsheet-list", getBuilder().path(FlowsheetsResources.class).build(assigningAuthority).toString());
    }

    public Link getFlowsheet(String flowsheetId) {
        return new Link("get-flowsheet", buildUrl(FlowsheetsResources.class, "get", assigningAuthority, flowsheetId));
    }

    public Link saveResult(String flowsheetId) {
        return new Link("save-observation-set", buildUrl(ObservationResources.class, "saveObservationResult", assigningAuthority, flowsheetId));
    }

    private String buildUrl(Class<?> resourceClass, String methodName, String... urlParameters) {
        return getBuilder().path(resourceClass)
                           .path(resourceClass, methodName)
                           .build((Object[]) urlParameters)
                           .toString();
    }

    private UriBuilder getBuilder() {
        return info.getBaseUriBuilder().clone();
    }

}
