package gov.va.vamf.service.clio.application.resources;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import gov.va.vamf.service.clio.infrastructure.security.*;
import gov.va.vamf.service.clio.application.representations.Link;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.ws.rs.*;
import javax.ws.rs.core.*;
import java.util.List;

/**
 * This rest service returns a resource-directory that is specific to the provider.
 */
@Path("/clio-service/resource-directory")
@Component
@Scope("request")
public class ResourceDirectoryResource {
    /**
     * Returns the Resource Directory for Clio Flow Sheets Resources
     *
     * @return List of links to top level resources.  All other resources are reached by links provided with return
     *         representations from other resources.
     */
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public List<Link> getResourceDirectory(@Context UriInfo u, @Context HttpHeaders headers) {
        Routes routes = createRoutesBuilder(u);
        String flowsheetPlaceholder = "{flowsheet-id}";

        return Lists.newArrayList(routes.getFlowsheetList(),
                                  routes.getFlowsheet(flowsheetPlaceholder),
                                  routes.saveResult(flowsheetPlaceholder));
    }

    public Routes createRoutesBuilder(UriInfo u) {
        UserServices userServices = new UserServices();

        try {
            return new Routes(u, userServices.getAssigningAuthority());
        } catch (UserServicesException e) {
            throw new ResourceDirectoryException(500, "Unable to retrieve resource directory.", Throwables.getRootCause(e).getMessage());
        }
    }
}
