package gov.va.vamf.service.clio.application.representations;

import com.google.common.base.Strings;
import gov.va.vamf.service.clio.observation.ObservationException;

import javax.xml.bind.annotation.*;

/**
 * Unique identifier for a term which could be a field, value or observation.
 */
@XmlRootElement(name = "unique_term_id", namespace = Namespace.ns)
public class UniqueTermId {

    /**
     * A Clio generated unique id (Guid), zero or one.  Zero represents false values and one represents true values.
     */
    @XmlElement(required = true)
    public String id;

    /**
     * A Clio generated flowsheet, field or value name.
     */
    @XmlElement(required = true)
    public String name;

    public UniqueTermId() {}

    public UniqueTermId(String id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        UniqueTermId uniqueTermId = (UniqueTermId) o;

        return id.equals(uniqueTermId.id) && name.equals(uniqueTermId.name);
    }

    @Override
    public int hashCode() {
        return 31 * id.hashCode() + name.hashCode();
    }

    public void validate() {
        if (Strings.isNullOrEmpty(id) || Strings.isNullOrEmpty(name))
            throw new ObservationException(400, "Invalid unique term id.  Valid id and name required.", "");
    }
}
