package gov.va.vamf.service.clio.application.representations;

import com.google.common.base.Strings;
import gov.va.vamf.service.clio.observation.ObservationException;

import javax.xml.bind.annotation.*;

/**
 * Patient's location when the observation(s) where made.
 */
@XmlRootElement(name = "location", namespace = Namespace.ns)
public class Location implements Comparable<Location> {

    /**
     * Unique identifier for Location.
     */
    @XmlElement(required = true)
    public long id;

    /**
     * Location name.
     */
    @XmlElement(required = true)
    public String name;

    @Override
    public int compareTo(Location location) {
        return name.compareTo(location.name);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Location location = (Location) o;

        return id == location.id && !(name != null ? !name.equals(location.name) : location.name != null);
    }

    @Override
    public int hashCode() {
        int result = (int) (id ^ id >>> 32);
        return 31 * result + (name != null ? name.hashCode() : 0);
    }

    public void validate() {
        if (id <= 0 || Strings.isNullOrEmpty(name))
            throw new ObservationException(400, "Invalid id or name.  Valid id and name required.", "");
    }
}
