package gov.va.vamf.service.clio.application.representations;

import javax.xml.bind.annotation.*;

/**
 * Represents a link to a resource.
 */
@XmlRootElement(name = "link", namespace = Namespace.ns)
public class Link {
    final public static String related = "related";
    final public static String self = "self";

    public Link() {}

    public Link(String title, String href) {
        this.title = title;
        this.href = href;
    }

    /**
     * Specifics relationship between the response content and the link.
     * Possible values are: related and self.
     * Most links will be related.
     */
    @XmlElement(name = "rel")
    public String rel = related;

    /**
     * An identifier used to represent a link that is constant for a given versions of the resources.
     */
    @XmlElement(name = "title")
    public String title = "";

    /**
     * URI of resource.
     */
    @XmlElement(name = "href")
    public String href = null;

    @Override
    public String toString() {
        return "{ \"rel\" : \"" + rel + "\" \"title\" : \"" + title + "\" \"href\" : \"" + href + "\" }";
    }
}
