package gov.va.vamf.service.clio.application.exceptions;

import org.slf4j.*;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.*;
import javax.ws.rs.core.Response.Status;
import java.util.UUID;

/**
 * Throws an error with JSON returned containing message, uuid, and detailedDescription.  The UI will
 * display message to the end user.
 */
public abstract class AbstractWebAppException extends WebApplicationException {
    private static Logger logger = LoggerFactory.getLogger(AbstractWebAppException.class);

    public AbstractWebAppException(Status responseStatus, String message, String detailedDescription) {
        this(responseStatus.getStatusCode(), message, detailedDescription);
    }

    public AbstractWebAppException(int responseStatus, String message, String detailedDescription) {
        this(UUID.randomUUID().toString(), responseStatus, message, detailedDescription);
    }

    private AbstractWebAppException(String id, int responseStatus, String message, String detailedDescription) {
        super(Response.status(responseStatus)
                .entity("{\"message\":\"" + message + "\", " +
                        "\"uuid\":\"" + id + "\", " +
                        "\"detailedDescription\":\"" + detailedDescription + "\"}")
                .type(MediaType.APPLICATION_JSON)
                .build());

        log(id, responseStatus, message, detailedDescription);
    }

    private void log(String id, int responseStatus, String message, String detailedDescription) {
        if (responseStatus >= 500)
            logger.error("Error Generated: " + message + " " + detailedDescription + "(" + id + ")");
        else
            logger.warn("Handled Error Generated: " + message + "(" + id + ")");
    }
}