package gov.va.vamf.service.clio.application.config;

import com.google.common.primitives.Ints;

/**
 * Add a Description.  Should include class purpose (why not what) and assumptions.
 */
public class VistaHost {
    public String assigningAuthority;
    public String host;
    public int port;

    public VistaHost(String hostPortConfig) {
        String[] hostPort = hostPortConfig.split(":");

        if (hostPort.length < 3 || Ints.tryParse(hostPort[2]) == null)
            throw new RuntimeException("Unable to parse host configuration from configuration file.  Format should be assigningAuthority:host:port.");

        assigningAuthority = hostPort[0];
        host = hostPort[1];
        port = Integer.parseInt(hostPort[2]);
    }

}
