package gov.va.vamf.service.clio.application.config;

import java.util.List;

import org.aeonbits.owner.Config;
import org.aeonbits.owner.Config.LoadPolicy;
import org.aeonbits.owner.Config.LoadType;
import org.aeonbits.owner.Config.Sources;

/**
 * Service configuration.
 */
@LoadPolicy(LoadType.MERGE)
@Sources({ "classpath:clio-resources/properties/ClioFlowsheetsConfig.properties",
        "classpath:ClioFlowsheetsConfig.properties"})
public interface ClioFlowsheetsConfig  extends Config {

    enum VistaBackends {mdws, jVista}

    @Key("clio.flowsheet.vista.backend")
    VistaBackends vistaBackend();

    @Key("clio.flowsheet.mdws.url")
    String clioMdwsUrl();
    
    @Key("clio.flowsheet.mdws.clio.mock.url")
    String mockClioMdwsUrl();

    @Key("clio.flowsheet.mdws.connection.timeout")
    int mdwsConnectionTimeOut();

    @Key("clio.flowsheet.mdws.read.timeout")
    int mdwsReadTimeOut();

    @Key("clio.flowsheet.cache.expiration")
    CacheTime cacheExpiration();

    @Key("clio.flowsheet.cache.refresh")
    CacheTime cacheRefresh();

    @Key("clio.flowsheet.vista.users")
    @Separator(";")
    List<User> vistaUsers();

    @Key("clio.flowsheet.vista.hosts")
    @Separator(";")
    List<VistaHost> vistaHosts();
}
