package gov.va.vamf.service.clio.application.config;

import com.google.common.base.*;
import com.google.common.primitives.*;

import java.util.concurrent.TimeUnit;

/**
 * Supports a durations and unit of time.
 */
public class CacheTime {
    private long duration = 24;
    private TimeUnit timeUnit = TimeUnit.HOURS;

    public CacheTime(String value) {
        String time = CharMatcher.JAVA_DIGIT.retainFrom(value);
        String unit = CharMatcher.JAVA_LETTER.retainFrom(value);

        if (Strings.isNullOrEmpty(time) || Strings.isNullOrEmpty(unit) ||
                !unit.matches("h|m|s") || Longs.tryParse(time) == null)
            throw new RuntimeException("Unable to parse cache duration from configuration file. Format should be [dd]ds where ddd are digits and s is either h, m or s.");

        duration = Longs.tryParse(time);
        timeUnit = unit.equals("h") ? TimeUnit.HOURS : unit.equals("m") ? TimeUnit.MINUTES : TimeUnit.SECONDS;
    }

    public long duration() {
        return duration;
    }

    public TimeUnit timeUnit() {
        return timeUnit;
    }
}
