package gov.va.vamf.service.clio.infrastructure.vista.mdws;

import gov.va.vamf.service.clio.application.config.ClioFlowsheetsConfig;
import gov.va.vamf.service.clio.infrastructure.security.UserServices;
import gov.va.vamf.service.clio.infrastructure.vista.*;
import org.aeonbits.owner.ConfigFactory;
import org.junit.*;

import static org.junit.Assert.*;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class ClioMdwsServiceTests {
    private ClioMdwsService service;

    @Before
    public void init() {
        ClioFlowsheetsConfig config = ConfigFactory.create(ClioFlowsheetsConfig.class, System.getProperties());
        service = new ClioMdwsService("123", config.mockClioMdwsUrl(), config.mdwsConnectionTimeOut(), config.mdwsReadTimeOut());
    }

    @Test
    public void mdwsReturnsSoapFault() {
        try {
            service.makeClioCall("InvalidMethod");
            fail("Failed because of a soap fault should have been thrown.");
        } catch (ClioMdwsException e) {
            assertTrue(e.getMessage().contains("Method not found."));
        }
    }

    @Test
    public void mdwsWrongUrlExcepition() {
        ClioMdwsService service = new ClioMdwsService("123", "http://IP__ADDRESS:PORT/OrderMgmtSvc.asmx?op=getCLIOFlowSheets", 100, 30000);

        try {
            service.makeClioCall("GetFlowsheetList");
            fail("Failed because an exception should have been thrown.");
        } catch (ClioMdwsException e) {
            assertTrue(e.getMessage().contains("connect timed out"));
        }
    }

    @Test
    public void makeSuccessfulMdwsCall() {
        ClioResultRecords resultRecords = service.makeClioCall("GetFlowsheetList", "123", "123");

        assertNotNull(resultRecords);
        assertTrue(resultRecords.hasNext());
    }
}
