package gov.va.vamf.service.clio.flowsheet.resources;

import com.jayway.restassured.response.Response;
import gov.va.vamf.service.clio.ResourceTest;
import org.junit.Test;

import java.util.ArrayList;

import static com.jayway.restassured.RestAssured.baseURI;
import static com.jayway.restassured.RestAssured.port;
import static org.hamcrest.Matchers.hasItems;
import static org.hamcrest.Matchers.is;

public class FlowsheetsResourcesTests extends ResourceTest {

    public static final String FLOWSHEETS_URI = "/ClioResources/rest/v1/clio-service/dfn-777/flowsheets";
    public static final String OBSERVATION_URI = "/ClioResources/rest/v1/clio-service/dfn-777/observation";

    @Test
    public void getFlowsheetList() {
        Response response = getRequestSpecWithBearerToken()
                .when()
                .get(FLOWSHEETS_URI)
                .then()
                .body("flowsheetItems.uniqueTermId.size()", is(3))
                .body("flowsheetItems.uniqueTermId.id", hasItems("{2b41adaf-76de-4083-85c7-b379974ac9e0}", "{c3f64a15-8764-4fdd-8fda-4e1747ad1d53}", "{d2f312e5-d0de-4caa-955e-d55ee5a7add4}"))
                .extract().response();

        ArrayList links = response.path("flowsheetItems.link");

        String uri = baseURI + ":" + port + FLOWSHEETS_URI;

        verifyLink(((ArrayList) links.get(0)).get(0), "get-flowsheet", uri + "/2b41adaf-76de-4083-85c7-b379974ac9e0");
        verifyLink(((ArrayList) links.get(1)).get(0), "get-flowsheet", uri + "/c3f64a15-8764-4fdd-8fda-4e1747ad1d53");
        verifyLink(((ArrayList) links.get(2)).get(0), "get-flowsheet", uri + "/d2f312e5-d0de-4caa-955e-d55ee5a7add4");
    }

    @Test
    public void getFlowsheet() {
        Response response = getRequestSpecWithBearerToken()
                .when()
                .get(FLOWSHEETS_URI + "/2b41adaf-76de-4083-85c7-b379974ac9e0")
                .then()
                .body("uniqueTermId.id", is("{2b41adaf-76de-4083-85c7-b379974ac9e0}"))
                .extract().response();

        ArrayList links = response.path("link");

        String uri = baseURI + ":" + port + OBSERVATION_URI;

        verifyLink(links.get(1), "save-observation-set", uri + "/2b41adaf-76de-4083-85c7-b379974ac9e0");
    }

    //Tests below here only for AgileX Vista verification

//    @Test
//    public void getAllFlowsheet() throws InterruptedException {
//        Response response = getRequestSpecWithBearerToken()
//                .when()
//                .get(FLOWSHEETS_URI + "/3BC56CB6-DE0A-4FEC-A76E-3BB5D94026CB")
//                .then()
//                .extract().response();
//
//        System.out.println(response.prettyPrint());
////        Thread.sleep(240000);
//
//        response = getRequestSpecWithBearerToken()
//                .when()
//                .get(FLOWSHEETS_URI + "/C4D8F659-E1DF-4E44-A65F-8B63B0846ADB")
//                .then()
//                .extract().response();
//
//        System.out.println(response.prettyPrint());
////        Thread.sleep(120000);
//
//        response = getRequestSpecWithBearerToken()
//                .when()
//                .get(FLOWSHEETS_URI + "/3E610D66-6AB2-4543-80ED-2B55869C2D63")
//                .then()
//                .extract().response();
//
//        System.out.println(response.prettyPrint());
////        Thread.sleep(240000);
//
//        response = getRequestSpecWithBearerToken()
//                .when()
//                .get(FLOWSHEETS_URI + "/0CF60069-BA57-44F8-ABAE-EAB2D163A246")
//                .then()
//                .extract().response();
//
//        System.out.println(response.prettyPrint());
////        Thread.sleep(360000);
//
//        response = getRequestSpecWithBearerToken()
//                .when()
//                .get(FLOWSHEETS_URI + "/1588A77B-0BF3-4D6A-98A0-67FDE331E675")
//                .then()
//                .extract().response();
//
//        System.out.println(response.prettyPrint());
////        Thread.sleep(30000);
//
//        response = getRequestSpecWithBearerToken()
//                .when()
//                .get(FLOWSHEETS_URI + "/8089E1E6-C99F-4D19-8064-530F7591227D")
//                .then()
//                .extract().response();
//
//        System.out.println(response.prettyPrint());
////        Thread.sleep(30000);
//
//        response = getRequestSpecWithBearerToken()
//                .when()
//                .get(FLOWSHEETS_URI + "/B052FB3B-C982-4326-84B1-EBE5594ABA40")
//                .then()
//                .extract().response();
//
//        System.out.println(response.prettyPrint());
////        Thread.sleep(30000);
//
//        response = getRequestSpecWithBearerToken()
//                .when()
//                .get(FLOWSHEETS_URI + "/176C34FF-5535-4F2E-8706-7CEF1399FF11")
//                .then()
//                .extract().response();
//
//        System.out.println(response.prettyPrint());
////        Thread.sleep(30000);
//
//        response = getRequestSpecWithBearerToken()
//                .when()
//                .get(FLOWSHEETS_URI + "/3FE057E8-6015-41B4-9A1E-8DB354F06B69")
//                .then()
//                .extract().response();
//
//        System.out.println(response.prettyPrint());
////        Thread.sleep(30000);
//
//        response = getRequestSpecWithBearerToken()
//                .when()
//                .get(FLOWSHEETS_URI + "/4A42D756-593F-4CC7-91AD-A4F3FBAF27E8")
//                .then()
//                .extract().response();
//
//        System.out.println(response.prettyPrint());
//    }

}
