package gov.va.vamf.service.clio.application.resources;

import com.jayway.restassured.response.Response;
import gov.va.vamf.service.clio.ResourceTest;
import org.junit.Test;

import java.util.ArrayList;

import static com.jayway.restassured.RestAssured.baseURI;
import static com.jayway.restassured.RestAssured.port;
import static org.hamcrest.Matchers.is;

public class ResourceDirectoryResourceTests extends ResourceTest {
    @Test
    public void getResourceDirectory() {
        Response response = getRequestSpecWithBearerToken()
                .when()
                .get("/ClioResources/rest/v1/clio-service/resource-directory")
                .then()
                .body("$.size()", is(3))
                .extract().response();

        ArrayList links = response.path("");

        String uri = baseURI + ":" + port;

        verifyLink(links.get(0), "get-flowsheet-list", uri + "/ClioResources/rest/v1/clio-service/dfn-777/flowsheets");
        verifyLink(links.get(1), "get-flowsheet", uri + "/ClioResources/rest/v1/clio-service/dfn-777/flowsheets/%7Bflowsheet-id%7D");
        verifyLink(links.get(2), "save-observation-set", uri + "/ClioResources/rest/v1/clio-service/dfn-777/observation/%7Bflowsheet-id%7D");
    }
}
