package gov.va.vamf.service.clio.mdws.service.model;

import gov.va.vamf.service.clio.mdws.service.FlowsheetRecordTemplates;
import gov.va.vamf.service.clio.mdws.service.FlowsheetRecordTemplates.RecordType;

import java.util.*;

public class ViewTerm {
    public String termId;
    public String displayName;
    public int termOrder;
    public int useDropDown;

    public List<Filter> filters;

    @Override
    public String toString() {
        FlowsheetRecordTemplates template = new FlowsheetRecordTemplates();
        return template.getRecord(RecordType.term, termOrder, termId, displayName, useDropDown);
    }

    public String getFilters() {
        FlowsheetRecordTemplates template = new FlowsheetRecordTemplates();

        StringBuilder builder = new StringBuilder();

        builder.append(template.getRecord(RecordType.filters, termOrder, "1", termId, "1"));

        if (filters != null) {
            Collections.sort(filters);

            for (Filter filter : filters) {
                builder.append(template.getRecord(RecordType.filters, termOrder, filter.type, filter.id, filter.required ? "1" : "0"));
            }
        }

        return builder.toString().replaceAll("<FILTER_TERM>null</FILTER_TERM>", "");
    }
}
