package gov.va.vamf.service.clio.mdws.service;

import java.io.InputStream;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TermRecordTemplate {
    private static NodeList termNodes;

    static {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setValidating(true);

        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
//            URL resource = Resources.getResource("Terminology.xml");
            InputStream resourceAsStream = TermRecordTemplate.class.getClassLoader().getResourceAsStream("Terminology.xml");
            
//            String xmlDoc = Resources.toString(resource, Charsets.UTF_8);
//            InputStream inputStream = IOUtils.toInputStream(xmlDoc);
            
            Document xmlDocument = builder.parse(resourceAsStream);
            termNodes = xmlDocument.getChildNodes();
        } catch( Exception e) {
            System.out.println("Exception trying to build Terminology from resource xml file. " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String getTerm(String termId) {
        if (termNodes == null)
            return "";

        Node termNode = findTermNode(termId);

        if (termNode == null)
            return "";
        else
            return nodeToString(termNode);
    }

    private Node findTermNode(String termId) {
        XPath xPath =  XPathFactory.newInstance().newXPath();

        try {
            return (Node) xPath.compile("//RECORD[ID='"+ termId + "']").evaluate(termNodes, XPathConstants.NODE);
        } catch (XPathExpressionException e) {
            System.out.println("Exception trying to get RECORD node for term id: " + termId + " " + e.getMessage());
            e.printStackTrace();
        }

        return null;
    }

    private String nodeToString(Node node) {
        StringWriter sw = new StringWriter();

        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();

            transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
            transformer.transform(new DOMSource(node), new StreamResult(sw));
        } catch (TransformerException te) {
            System.out.println("Exception trying transform node to string." + te.getMessage());
            te.printStackTrace();
        }

        return sw.toString().replaceAll("\t", "").replaceAll(System.getProperty("line.separator"), "");
    }
}
