package gov.va.vamf.service.clio.mdws.service;

import org.w3c.dom.*;

import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.*;
import javax.xml.xpath.*;
import java.io.InputStream;
import java.util.Iterator;

public class GuidParameterExtractor {

    public String fromSoapMessage(InputStream message) {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setValidating(true);

        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(message);
            NodeList messageNodes = xmlDocument.getChildNodes();

            XPath xPath = getxPath();
            return (String) xPath.compile("//executeCLIOCommand/inputFields/text()").evaluate(messageNodes, XPathConstants.STRING);

        } catch (Exception e) {
            System.out.println("Exception trying to read guid from soap message. " + e.getMessage());
            e.printStackTrace();
        }

        return "";
    }

    private XPath getxPath() {
        XPath xPath =  XPathFactory.newInstance().newXPath();

        xPath.setNamespaceContext(new NamespaceContext() {
            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix.equals("soap"))
                    return "http://www.w3.org/2003/05/soap-envelope";

                if(prefix.equals("om"))
                    return "http://DNS   /ClioSvc";

                return XMLConstants.NULL_NS_URI;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Iterator getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });

        return xPath;
    }

}
