package gov.va.vamf.service.clio.mdws.service;

import java.net.URL;
import java.util.Map;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;

public class FlowsheetRecordTemplates {
    public enum RecordType{flowsheet, view, term, unit, qualifier, filters}

    private static Map<RecordType, String> templates = Maps.newHashMap();

    static {
        templates.put(RecordType.flowsheet, getTemplate("FlowsheetListRecordTemplate.txt"));
        templates.put(RecordType.view, getTemplate("FlowsheetPageListRecordTemplate.txt"));
        templates.put(RecordType.term, getTemplate("FlowsheetViewTermsRecordTemplate.txt"));
        templates.put(RecordType.unit, getTemplate("TermUnitPairRecordTemplate.txt"));
        templates.put(RecordType.qualifier, getTemplate("TermQualifierPairRecordTemplate.txt"));
        templates.put(RecordType.filters, getTemplate("FlowsheetViewFiltersRecordTemplate.txt"));
    }

    public static String getTemplate(String fileName) {
        String template = "";

        try {
            URL resource = Resources.getResource(fileName);
            template = removeFormatting(Resources.toString(resource, Charsets.UTF_8));
        } catch (Exception e) {
            System.out.println("Exception trying to read template file: " + fileName + " " + e.getMessage());
            e.printStackTrace();
        }

        return template;
    }

    private static String removeFormatting(String value) {
        return value.replaceAll(System.getProperty("line.separator"), "").replaceAll(" ", "");
    }

    public String getRecord(RecordType type, Object... paramters) {
        String template = templates.get(type);

        return String.format(template, paramters);
    }

    public String removeNullComment(String record) {
        return record.replace("<COMMENT>null</COMMENT>", "");
    }
}
