/*
 * Decompiled with CFR 0.152.
 */
package org.missinglink.tools;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class StreamUtils {
    protected StreamUtils() {
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        int pageSize = 1024;
        byte[] buf = new byte[1024];
        int ret = is.read(buf, 0, 1024);
        while (ret > 0) {
            byte[] bufPage = new byte[ret];
            for (int i = 0; i < ret; ++i) {
                bufPage[i] = buf[i];
            }
            sb.append(new String(bufPage));
            ret = is.read(buf, 0, 1024);
        }
        in.close();
        return sb.toString();
    }

    public static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        return StreamUtils.inputStreamToByteArrayOutputStream(is).toByteArray();
    }

    public static ByteArrayOutputStream inputStreamToByteArrayOutputStream(InputStream is) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int pageSize = 1024;
        byte[] buf = new byte[1024];
        int ret = is.read(buf, 0, 1024);
        while (ret > 0) {
            byte[] bufPage = new byte[ret];
            for (int i = 0; i < ret; ++i) {
                bufPage[i] = buf[i];
            }
            out.write(bufPage);
            ret = is.read(buf, 0, 1024);
        }
        in.close();
        return out;
    }
}

