/*
 * Decompiled with CFR 0.152.
 */
package org.missinglink.http.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManagerFactory;
import org.missinglink.http.client.HttpMethod;
import org.missinglink.http.client.HttpResponse;
import org.missinglink.http.encoding.Base64;
import org.missinglink.http.exception.HttpCertificateException;
import org.missinglink.http.exception.HttpInvocationException;
import org.missinglink.http.exception.InvalidStreamException;
import org.missinglink.http.exception.InvalidUriException;
import org.missinglink.tools.StreamUtils;

public class HttpClient {
    protected static final String UTF_8 = "UTF-8";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String ACCEPT = "Accept";
    public static final String CONTENT_TYPE = "Content-Type";
    protected String protocol;
    protected String host;
    protected Integer port;
    protected String path;
    protected HttpMethod method = HttpMethod.GET;
    protected String username;
    protected String password;
    protected InputStream entity;
    protected boolean binaryEntity = false;
    protected InputStream keyStore;
    protected String keyStorePassword;
    protected Map<String, String> queryUnencoded = new HashMap<String, String>();
    protected Map<String, String> queryEncoded = new HashMap<String, String>();
    protected Map<String, String> headers = new HashMap<String, String>();

    protected HttpClient() {
    }

    public static HttpClientBuilder uri(String uri) throws InvalidUriException {
        return new HttpClientBuilder(new HttpClient(), uri);
    }

    public HttpClientBuilder build() {
        return new HttpClientBuilder(this);
    }

    public String getEntityAsString() throws IOException {
        if (null == this.entity || this.entity.available() == 0) {
            return null;
        }
        this.entity.mark(this.entity.available());
        String tmp = StreamUtils.inputStreamToString(this.entity);
        this.entity.reset();
        return tmp;
    }

    public byte[] getEntityAsByteArray() throws IOException {
        if (null == this.entity || this.entity.available() == 0) {
            return null;
        }
        this.entity.mark(this.entity.available());
        byte[] result = StreamUtils.inputStreamToByteArray(this.entity);
        this.entity.reset();
        return result;
    }

    public HttpResponse invoke() throws HttpInvocationException, HttpCertificateException {
        try {
            HttpResponse response = new HttpResponse(this);
            String uri = this.getUri();
            URL url = new URL(uri);
            HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
            httpUrlConnection.setDoInput(true);
            httpUrlConnection.setRequestMethod(this.method.name());
            if (HTTPS.equalsIgnoreCase(this.protocol) && null != this.keyStore) {
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(this.keyStore, null == this.keyStorePassword ? new char[]{} : this.keyStorePassword.toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ks);
                SSLContext ssl = SSLContext.getInstance("TLS");
                ssl.init(null, tmf.getTrustManagers(), null);
                ((HttpsURLConnection)httpUrlConnection).setSSLSocketFactory(ssl.getSocketFactory());
            }
            if (null != this.username && this.username.length() > 0) {
                String userpass = this.username + ":" + (null == this.password ? "" : this.password);
                String basicAuth = "Basic " + new String(Base64.encodeBytes(userpass.getBytes()));
                httpUrlConnection.setRequestProperty("Authorization", basicAuth);
            }
            if (null != this.headers && this.headers.size() > 0) {
                for (Map.Entry<String, String> header : this.headers.entrySet()) {
                    httpUrlConnection.setRequestProperty(header.getKey(), header.getValue());
                }
            }
            if (null != this.entity) {
                httpUrlConnection.setDoOutput(true);
                if (this.binaryEntity) {
                    httpUrlConnection.getOutputStream().write(this.getEntityAsByteArray());
                    httpUrlConnection.getOutputStream().close();
                } else {
                    OutputStreamWriter writer = new OutputStreamWriter(httpUrlConnection.getOutputStream());
                    String entityAsString = this.getEntityAsString();
                    writer.write(entityAsString);
                    writer.close();
                }
            }
            try {
                InputStream responseEntityInputStream = httpUrlConnection.getInputStream();
                if (null != responseEntityInputStream) {
                    response.setEntity(StreamUtils.inputStreamToByteArray(responseEntityInputStream));
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            InputStream errorEntityInputStream = httpUrlConnection.getErrorStream();
            if (null != errorEntityInputStream) {
                response.setEntity(StreamUtils.inputStreamToByteArray(errorEntityInputStream));
            }
            response.setStatus(httpUrlConnection.getResponseCode());
            response.setMessage(httpUrlConnection.getResponseMessage());
            response.setContentEncoding(httpUrlConnection.getContentEncoding());
            response.setContentLength(httpUrlConnection.getContentLength());
            response.setContentType(httpUrlConnection.getContentType());
            response.setDate(0L == httpUrlConnection.getDate() ? null : new Date(httpUrlConnection.getDate()));
            response.setExpires(0L == httpUrlConnection.getExpiration() ? null : new Date(httpUrlConnection.getExpiration()));
            response.setLastModified(0L == httpUrlConnection.getLastModified() ? null : new Date(httpUrlConnection.getLastModified()));
            if (null != httpUrlConnection.getHeaderFields() && httpUrlConnection.getHeaderFields().size() > 0) {
                for (Map.Entry<String, List<String>> entry : httpUrlConnection.getHeaderFields().entrySet()) {
                    response.getHeaders().put(entry.getKey(), entry.getValue());
                }
            }
            httpUrlConnection.disconnect();
            return response;
        }
        catch (SSLHandshakeException e) {
            throw new HttpCertificateException(e);
        }
        catch (Throwable t) {
            throw new HttpInvocationException(t);
        }
    }

    public String getUri() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.protocol.toLowerCase()).append("://").append(this.host);
        if (null != this.port) {
            sb.append(":").append(this.port);
        }
        if (null != this.path && this.path.length() > 0) {
            sb.append(this.path);
        } else {
            sb.append("/");
        }
        if (this.queryEncoded.size() > 0) {
            sb.append("?");
            boolean first = true;
            for (Map.Entry<String, String> qp : this.queryEncoded.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("&");
                }
                sb.append(qp.getKey());
                if (null == qp.getValue()) continue;
                sb.append("=").append(qp.getValue());
            }
        }
        return sb.toString();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public InputStream getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public Map<String, String> getQueryUnencoded() {
        return this.queryUnencoded;
    }

    public Map<String, String> getQueryEncoded() {
        return this.queryEncoded;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public InputStream getEntity() {
        return this.entity;
    }

    public static class HttpClientBuilder {
        protected HttpClient httpClient;

        protected HttpClientBuilder(HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        protected HttpClientBuilder(HttpClient httpClient, String uri) throws InvalidUriException {
            this.httpClient = httpClient;
            this.parseUri(uri);
        }

        protected void parseUri(String uri) throws InvalidUriException {
            try {
                int queryIndex = uri.lastIndexOf("?");
                boolean uriHasQuery = queryIndex != -1;
                String query = uriHasQuery ? uri.substring(queryIndex + 1) : null;
                URI safeUri = new URI(uriHasQuery ? uri.substring(0, queryIndex) : uri);
                this.httpClient.protocol = safeUri.getScheme();
                this.httpClient.host = safeUri.getHost();
                this.httpClient.port = safeUri.getPort() != -1 ? Integer.valueOf(safeUri.getPort()) : null;
                this.httpClient.path = safeUri.getPath();
                this.parseQuery(query);
                if (!safeUri.getScheme().toLowerCase().equals(HttpClient.HTTP) && !safeUri.getScheme().toLowerCase().equals(HttpClient.HTTPS)) {
                    throw new InvalidUriException(uri);
                }
            }
            catch (Throwable t) {
                throw new InvalidUriException(t);
            }
        }

        protected void parseQuery(String query) {
            if (null != query && query.length() > 0) {
                String[] queryParts;
                for (String queryPart : queryParts = query.split("&")) {
                    String[] keyValue = queryPart.split("=");
                    this.httpClient.queryUnencoded.put(keyValue[0], keyValue.length > 1 ? keyValue[1] : null);
                }
            }
            for (Map.Entry<String, String> entry : this.httpClient.queryUnencoded.entrySet()) {
                this.httpClient.queryEncoded.put(entry.getKey(), this.encode(entry.getValue()));
            }
        }

        protected String encode(String str) {
            try {
                return null == str ? null : URLEncoder.encode(str, HttpClient.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }

        public HttpClient toHttpClient() {
            return this.httpClient;
        }

        public HttpClientBuilder query(String param, String value) {
            if (null != param && param.length() > 0) {
                this.httpClient.queryUnencoded.put(param, value);
                this.httpClient.queryEncoded.put(param, this.encode(value));
            }
            return this;
        }

        public HttpClientBuilder header(String header, String value) {
            if (null != header && header.length() > 0) {
                this.httpClient.headers.put(header, value);
            }
            return this;
        }

        public HttpClientBuilder accept(String value) {
            this.httpClient.headers.put(HttpClient.ACCEPT, value);
            return this;
        }

        public HttpClientBuilder contentType(String value) {
            this.httpClient.headers.put(HttpClient.CONTENT_TYPE, value);
            return this;
        }

        public HttpClientBuilder method(HttpMethod method) {
            this.httpClient.method = method;
            return this;
        }

        public HttpClientBuilder get() {
            this.httpClient.method = HttpMethod.GET;
            return this;
        }

        public HttpClientBuilder post() {
            this.httpClient.method = HttpMethod.POST;
            return this;
        }

        public HttpClientBuilder put() {
            this.httpClient.method = HttpMethod.PUT;
            return this;
        }

        public HttpClientBuilder trace() {
            this.httpClient.method = HttpMethod.TRACE;
            return this;
        }

        public HttpClientBuilder options() {
            this.httpClient.method = HttpMethod.OPTIONS;
            return this;
        }

        public HttpClientBuilder delete() {
            this.httpClient.method = HttpMethod.DELETE;
            return this;
        }

        public HttpClientBuilder head() {
            this.httpClient.method = HttpMethod.HEAD;
            return this;
        }

        public HttpClientBuilder credentials(String username, String password) {
            this.httpClient.username = username;
            this.httpClient.password = password;
            return this;
        }

        public HttpClientBuilder entity(InputStream is, boolean binary) throws InvalidStreamException {
            if (null != is && !is.markSupported()) {
                throw new InvalidStreamException("InputStream of type [" + is.getClass().getName() + "] does not support marking");
            }
            this.httpClient.entity = is;
            this.httpClient.binaryEntity = binary;
            return this;
        }

        public HttpClientBuilder entity(InputStream is) throws InvalidStreamException {
            return this.entity(is, false);
        }

        public HttpClientBuilder entity(String str, boolean binary) {
            if (null != str) {
                this.httpClient.entity = new ByteArrayInputStream(str.getBytes());
                this.httpClient.binaryEntity = binary;
            }
            return this;
        }

        public HttpClientBuilder entity(String str) {
            return this.entity(str, false);
        }

        public HttpClientBuilder keyStore(InputStream is, String password) {
            this.httpClient.keyStore = is;
            this.httpClient.keyStorePassword = password;
            return this;
        }
    }
}

