/*
 * Decompiled with CFR 0.152.
 */
package org.missinglink.ant.task.http;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.missinglink.ant.task.http.CredentialsNode;
import org.missinglink.ant.task.http.EntityNode;
import org.missinglink.ant.task.http.HeaderNode;
import org.missinglink.ant.task.http.HeadersNode;
import org.missinglink.ant.task.http.KeyStoreNode;
import org.missinglink.ant.task.http.QueryNode;
import org.missinglink.ant.task.http.QueryParameterNode;
import org.missinglink.http.client.HttpClient;
import org.missinglink.http.client.HttpMethod;
import org.missinglink.http.exception.HttpCertificateException;
import org.missinglink.http.exception.HttpInvocationException;

public class HttpClientTask
extends Task {
    protected String url;
    protected String statusProperty;
    protected String entityProperty;
    protected File outFile;
    protected HttpMethod method;
    protected CredentialsNode credentials;
    protected KeyStoreNode keystore;
    protected EntityNode entity;
    protected HeadersNode headers;
    protected QueryNode query;
    protected boolean printRequest;
    protected boolean printResponse;
    protected boolean printRequestHeaders = true;
    protected boolean printResponseHeaders = true;
    protected int expected = 200;
    protected boolean failOnUnexpected = true;
    protected boolean update = true;
    protected HttpClient httpClient;

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void execute() {
        super.execute();
        this.initHttpClient();
        if (!this.outputIsAvailable()) {
            this.log("Output Entity file " + this.safeOutFilename() + " already exists, update is set to " + this.update + ", skipping HTTP request", 2);
            return;
        }
        response = null;
        this.log("********************", 3);
        this.log("HTTP Request", 2);
        this.log("********************", 2);
        uri = this.httpClient.getUri();
        this.log("URL:\t\t" + uri, 2);
        this.log("Method:\t\t" + this.httpClient.getMethod().name(), 2);
        if (null != this.credentials && this.credentials.isValid()) {
            this.log("Credentials:\t" + (this.credentials.isShow() != false ? this.credentials.getUsername() + " / " + this.credentials.getPassword() : "[hidden]"), 3);
        }
        if (this.httpClient.getHeaders().size() > 0) {
            this.log("Headers:\t\tyes", 3);
            for (Map.Entry<String, Object> entry : this.httpClient.getHeaders().entrySet()) {
                this.log("\t" + entry.getKey() + ": " + entry.getValue());
            }
        } else {
            this.log("Headers:\t\tno", 3);
        }
        if (this.httpClient.getQueryUnencoded().size() > 0) {
            this.log("Query Parameters:\tyes", 3);
            for (Map.Entry<String, Object> entry : this.httpClient.getQueryUnencoded().entrySet()) {
                this.log("\t" + entry.getKey() + "=" + entry.getValue(), 3);
            }
        } else {
            this.log("Query Parameters:\tno", 3);
        }
        if (this.printRequest) {
            this.log("Entity:\t\t" + (null == this.httpClient.getEntity() ? "no" : "yes"), 2);
        } else {
            this.log("Entity:\t\t" + (null == this.httpClient.getEntity() ? "no" : "yes"), 3);
        }
        if (null != this.httpClient.getEntity() && this.printRequest) {
            try {
                this.log("------ BEGIN ENTITY ------", 2);
                this.log(this.httpClient.getEntityAsString(), 2);
                this.log("------- END ENTITY -------", 2);
            }
            catch (IOException e) {
                this.log(e, 0);
                throw new BuildException((Throwable)e);
            }
        }
        try {
            response = this.httpClient.invoke();
        }
        catch (HttpInvocationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (HttpCertificateException e) {
            throw new BuildException((Throwable)e);
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
        if (null != response) {
            if (null != this.getStatusProperty() && this.getStatusProperty().length() > 0) {
                this.getProject().setProperty(this.getStatusProperty(), Integer.toString(response.getStatus()));
            }
            this.log("", 2);
            this.log("********************", 3);
            this.log("HTTP Response", 2);
            this.log("********************", 2);
            this.log("Status:\t\t" + response.getStatus(), 2);
            if (response.getHeaders().size() > 0) {
                this.log("Headers:\t\tyes", 3);
                for (Map.Entry<String, Object> entry : response.getHeaders().entrySet()) {
                    for (String value : (List)entry.getValue()) {
                        if (null == entry.getKey()) {
                            this.log("\t" + value, 3);
                            continue;
                        }
                        this.log("\t" + entry.getKey() + ": " + value, 3);
                    }
                }
            } else {
                this.log("Headers:\t\tno");
            }
            v0 = responseHasEntity = null != response.getEntity();
            if (null == this.outFile) {
                if (this.printResponse) {
                    this.log("Entity:\t\t" + (null == response.getEntity() ? "no" : "yes"), 2);
                } else {
                    this.log("Entity:\t\t" + (null == response.getEntity() ? "no" : "yes"), 3);
                }
                if (responseHasEntity) {
                    try {
                        respEntity = response.getEntityAsString();
                        if (null != this.getEntityProperty() && this.getEntityProperty().length() > 0) {
                            this.getProject().setProperty(this.getEntityProperty(), respEntity);
                        }
                        if (!this.printResponse) ** GOTO lbl102
                        this.log("------ BEGIN ENTITY ------", 2);
                        this.log(respEntity, 2);
                        this.log("------- END ENTITY -------", 2);
                    }
                    catch (IOException e) {
                        this.log(e, 0);
                        throw new BuildException((Throwable)e);
                    }
                }
            } else if (responseHasEntity) {
                try {
                    HttpClientTask.mkdirs(this.outFile);
                    fos = new BufferedOutputStream(new FileOutputStream(this.outFile));
                    fos.write(response.getEntity());
                    fos.flush();
                    fos.close();
                    this.log("Entity written to file:\t" + this.outFile.getAbsolutePath(), 2);
                }
                catch (Throwable t) {
                    throw new BuildException("Failed to write response entity to file: " + this.outFile.getAbsolutePath(), t);
                }
            }
lbl102:
            // 6 sources

            if (response.getStatus() != this.expected && this.failOnUnexpected) {
                throw new BuildException("Expected Status [" + this.expected + "] but got [" + response.getStatus() + "] for URI [" + uri + "]");
            }
        }
    }

    protected boolean outputIsAvailable() {
        return this.outFile == null || !this.outFile.exists() || this.update;
    }

    protected String safeOutFilename() {
        if (null != this.outFile) {
            return this.outFile.getAbsolutePath();
        }
        return "";
    }

    protected static void mkdirs(File file) {
        boolean mkdirs;
        File dir = file.getParentFile();
        if (!dir.exists() && !(mkdirs = dir.mkdirs())) {
            throw new BuildException("Could not make directories for " + dir.getAbsolutePath());
        }
    }

    protected void initHttpClient() {
        try {
            HttpClient.HttpClientBuilder builder = HttpClient.uri(this.url);
            builder = builder.method(null == this.method ? HttpMethod.GET : this.method);
            if (null != this.credentials && this.credentials.isValid()) {
                builder = builder.credentials(this.credentials.getUsername(), this.credentials.getPassword());
            }
            if (null != this.keystore && this.keystore.isValid()) {
                builder = builder.keyStore(new FileInputStream(this.keystore.getFile()), this.keystore.getPassword());
            }
            if (null != this.headers && this.headers.isValid()) {
                for (HeaderNode header : this.headers.getHeaders()) {
                    builder = builder.header(header.getName(), header.getValue());
                }
            }
            if (null != this.query && this.query.isValid()) {
                for (QueryParameterNode qp : this.query.getParameters()) {
                    builder = builder.query(qp.getName(), qp.getValue());
                }
            }
            if (null != this.entity && this.entity.isValid()) {
                if (null != this.entity.getFile()) {
                    FileInputStream is = new FileInputStream(this.entity.getFile());
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    try {
                        int num;
                        while ((num = is.read(buf)) != -1) {
                            os.write(buf, 0, num);
                        }
                    }
                    catch (IOException e) {
                        throw new BuildException((Throwable)e);
                    }
                    builder = builder.entity(new ByteArrayInputStream(os.toByteArray()), this.entity.getBinary());
                } else {
                    builder = null != this.entity.getValue() && this.entity.getValue().length() > 0 ? builder.entity(this.entity.getValue()) : builder.entity(this.entity.getText(), this.entity.getBinary());
                }
            }
            this.httpClient = builder.toHttpClient();
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
    }

    public void addConfiguredCredentials(CredentialsNode credentials) {
        this.credentials = credentials;
    }

    public void addConfiguredKeystore(KeyStoreNode keystore) {
        this.keystore = keystore;
    }

    public void addConfiguredEntity(EntityNode entity) {
        this.entity = entity;
    }

    public void addConfiguredHeaders(HeadersNode headers) {
        this.headers = headers;
    }

    public void addConfiguredQuery(QueryNode query) {
        this.query = query;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public File getOutfile() {
        return this.outFile;
    }

    public void setOutfile(File outFile) {
        this.outFile = outFile;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setPrintrequest(boolean printRequest) {
        this.printRequest = printRequest;
    }

    public void setPrintresponse(boolean printResponse) {
        this.printResponse = printResponse;
    }

    public void setExpected(int expected) {
        this.expected = expected;
    }

    public void setFailonunexpected(boolean failOnUnexpected) {
        this.failOnUnexpected = failOnUnexpected;
    }

    public void setPrintresponseheaders(boolean printResponseHeaders) {
        this.printResponseHeaders = printResponseHeaders;
    }

    public void setPrintrequestheaders(boolean printRequestHeaders) {
        this.printRequestHeaders = printRequestHeaders;
    }

    public String getStatusProperty() {
        return this.statusProperty;
    }

    public void setStatusProperty(String statusProperty) {
        this.statusProperty = statusProperty;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public String getEntityProperty() {
        return this.entityProperty;
    }

    public void setEntityProperty(String entityProperty) {
        this.entityProperty = entityProperty;
    }
}

