spool create_liquibase.log

WHENEVER SQLERROR EXIT SQL.SQLCODE

declare
	v_count number(1);
  	v_sql varchar2(500);
  
begin
	select count(1) into v_count from DBA_TABLESPACES where TABLESPACE_NAME= 'LIQUIBASE_DATA';
	if v_count = 0 then
    v_sql := 'CREATE TABLESPACE LIQUIBASE_DATA DATAFILE ''&1/liquibase_data01.dbf'' SIZE 16M autoextend on next 4M';
		EXECUTE IMMEDIATE v_sql;
  	end if;		
  	select count(1) into v_count from DBA_USERS where USERNAME = 'LIQUIBASE';
  	if v_count = 0 then
      v_sql := 'CREATE USER LIQUIBASE IDENTIFIED BY &2 DEFAULT TABLESPACE LIQUIBASE_DATA QUOTA unlimited ON LIQUIBASE_DATA';
      EXECUTE IMMEDIATE v_sql;
    end if;
end;
/
grant create session to liquibase;
grant create table to liquibase;

spool off