package com.agilex.vamf.metrics.testutility;

import com.agilex.vamf.metrics.clientapi.AuthenticationInfo;
import com.agilex.vamf.metrics.clientapi.MobileHealthClientTestVersion;
import com.agilex.vamf.metrics.testutility.IntegrationTestConfiguration;

public class TestHelper {

    public static MobileHealthClientTestVersion createMobileHealthClient(String username, String password, String authType) {
		AuthenticationInfo authenticationInfo = new AuthenticationInfo(username, password, authType);
		return createMobileHealthClient(authenticationInfo);
	}
	
	public static MobileHealthClientTestVersion createMobileHealthClient(AuthenticationInfo authenticationInfo) {
		String uri = IntegrationTestConfiguration.getMetricsRestServiceBaseUri();
		MobileHealthClientTestVersion mobileHealthClient = new MobileHealthClientTestVersion(uri, authenticationInfo);
		return mobileHealthClient;
	}
	
        public static MobileHealthClientTestVersion createProviderMobileHealthClient() {
            AuthenticationInfo authenticationInfo = IntegrationTestConfiguration.getProviderAuthenticationInformation();
            return createMobileHealthClient(authenticationInfo);
        }	

	public static boolean beginsWith(String value, String compareTo) {
		int length = compareTo.length();
		String beginning = value.substring(0, length);
		return beginning.toLowerCase().contentEquals(compareTo.toLowerCase());
	}

	

}
