package com.agilex.vamf.metrics.testutility;

import java.net.URI;
import java.util.Map;

import javax.ws.rs.core.UriBuilder;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.agilex.vamf.metrics.clientapi.AuthenticationInfo;
import com.agilex.vamf.metrics.testutility.IntegrationTestConfiguration;


@SuppressWarnings("unchecked")
public class IntegrationTestConfiguration {

    //public static final String CONFIGURATION_FILENAME = "/spring/config/va-veteran-dev/integrationTestConfiguration-va-veteran-dev.xml";
    public static final String CONFIGURATION_FILENAME = "integrationApplicationContext.xml";
    private static Map<String, String> properties = null;
    private static BeanFactory factory;

    static {
        factory = new ClassPathXmlApplicationContext(new String[] { CONFIGURATION_FILENAME });
        properties = (Map<String, String>) factory.getBean("configProperties");
    }

    public static String getMetricsRestServiceBaseUri() {
        return getProperty("MetricsServiceRestURI");
    }
    
    public static URI getAuditUri(){
    	return UriBuilder.fromUri(IntegrationTestConfiguration.getMetricsRestServiceBaseUri()).path("audit").build();
    }
    public static URI getAuditHybridAppUri(){
    	return UriBuilder.fromUri(IntegrationTestConfiguration.getMetricsRestServiceBaseUri()).path("audit-basic").build();
    }

    public static String getMHPAuthorizeURI() {
        return getProperty("MHPAuthorizeURI");
    }

    public static String getMHPTokenURI() {
        return getProperty("MHPTokenURI");
    }

    public static String getMHBaseURI() {
        return getProperty("MHPBaseURI");
    }

    public static AuthenticationInfo getAuthenticationInformation() {
        AuthenticationInfo authenticationInfo = null;
        if (getAuthType() != null) {
            authenticationInfo = new AuthenticationInfo();
            authenticationInfo.setUsername(getUsername());
            authenticationInfo.setPassword(getPassword());
            authenticationInfo.setAuthtype(getAuthType());
            authenticationInfo.setFacilityName(getFacilityName());
            authenticationInfo.setFacilityCode(getFacilityCode());
        }
        return authenticationInfo;
    }

    public static AuthenticationInfo getProviderAuthenticationInformation() {
        AuthenticationInfo authenticationInfo = null;
        if (getAuthType() != null) {
            authenticationInfo = new AuthenticationInfo();
            authenticationInfo.setUsername("doc123");
            authenticationInfo.setPassword("doc123!!");
            authenticationInfo.setAuthtype(getAuthType());
            authenticationInfo.setFacilityName("DC VAMC");
            authenticationInfo.setFacilityCode("688");
        }
        return authenticationInfo;
    }

    private static String getUsername() {
        return getProperty("username");
    }

    private static String getPassword() {
        return getProperty("password");
    }

    private static String getAuthType() {
        String authtype = getProperty("authtype");
        return authtype;
    }

    private static String getFacilityName() {
        String authtype = getProperty("facilityName");
        return authtype;
    }

    private static String getFacilityCode() {
        String authtype = getProperty("facilityCode");
        return authtype;
    }

    private static String getProperty(String key) {
        return properties.get(key);
    }

}
