package com.agilex.vamf.metrics.restservice;

import java.net.URI;

import javax.ws.rs.core.MediaType;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.vamf.metrics.clientapi.MobileHealthClientTestVersion;
import com.agilex.vamf.metrics.domain.ServiceTiming;
import com.agilex.vamf.metrics.testutility.IntegrationTestConfiguration;
import com.agilex.vamf.metrics.testutility.TestHelper;

public class ServiceWithOAuthProviderTest {

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void setup() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-prod"));
		client = TestHelper.createProviderMobileHealthClient();
    }
	
	@AfterClass
	public static void destroyClient() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	@Test
	public void saveMetric() {
		URI metricUri = IntegrationTestConfiguration.getAuditUri();
		ServiceTiming timingDto = new ServiceTiming();
		timingDto.setStartDate(DateHelper.getToday());
		timingDto.setAppName("Metrics Service");
		timingDto.setUserId("TEST_USER_ID");
		timingDto.setEvent("Testing Save Metrics From AuditResource Int. test - prov");
		timingDto.appendTag("APP_VERSION", "v4.0.0");
		timingDto.appendTag("c", "TestClass");
		timingDto.appendTag("m", "deleteToken");
		timingDto.appendTag("status", "Success");	
		
		client.getJerseyClient().resource(metricUri).type(MediaType.APPLICATION_JSON).accept("application/json").post(timingDto);
	}
	
}
