package com.agilex.vamf.metrics.restservice;

import java.net.URI;

import javax.ws.rs.core.MediaType;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.sun.jersey.api.client.Client;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.vamf.metrics.clientapi.AuthenticationInfo;
import com.agilex.vamf.metrics.domain.ServiceTiming;
import com.agilex.vamf.metrics.testutility.IntegrationTestConfiguration;
import com.agilex.vamf.metrics.testutility.TestHelper;

public class ServiceWithBasicAuthVetModeTest {
	
	private static final String HOMELESS_USERNAME = "homeless";
	private static final String HOMELESS_PWD = "homeless0!";
	private static final String HOMELESS_APP = "Homeless";
	
	private static Client jerseyClient;
	
	@Before
	public void setUp() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
		jerseyClient = TestHelper.createMobileHealthClient(HOMELESS_USERNAME, HOMELESS_PWD, AuthenticationInfo.BASIC_AUTHENTICATION).getJerseyClient();	
	}

	@Test
	public void saveMetric_postive() {
		ServiceTiming timing = new ServiceTiming();
		timing.setStartDate(DateHelper.getToday());
		timing.setAppName(HOMELESS_APP);
		timing.setUserId("24478");
		timing.setEvent("Test basic authentication in veteran-dev-mode");
		timing.appendTag("APP_VERSION", "v1.0.0");
		timing.appendTag("VISN", "3");
		timing.setEndDate(DateHelper.getToday());
		
		URI uri = getAuditBasicUri();
		jerseyClient.resource(uri).type(MediaType.APPLICATION_XML).accept("application/xml").post(timing);
	}

        @Test
        public void saveMetric_negative() {
                jerseyClient = TestHelper.createMobileHealthClient(HOMELESS_USERNAME, HOMELESS_PWD, AuthenticationInfo.BASIC_AUTHENTICATION).getJerseyClient();
                ServiceTiming timing = new ServiceTiming();
                timing.setStartDate(DateHelper.getToday());
                timing.setAppName(HOMELESS_APP);
                timing.setUserId("24478");
                timing.setEvent("Test basic authentication in veteran-dev-mode");
                timing.appendTag("APP_VERSION", "v1.0.0");
                timing.appendTag("VISN", "3");
                timing.setEndDate(DateHelper.getToday());
                
                URI uri = getAuditBasicUri();
                try {
                    jerseyClient.resource(uri).type(MediaType.APPLICATION_XML).accept("application/xml").post(timing);    
                } catch (Exception e) {
                    assert(e.getMessage().contains("401 Unauthorized"));
                }                
        }
	
	private URI getAuditBasicUri(){
		return IntegrationTestConfiguration.getAuditHybridAppUri();
	}
	
	@AfterClass
	public static void destroyClient() {
		if (jerseyClient != null) {
			jerseyClient.destroy();
		}
	}
}

