package com.agilex.vamf.metrics.clientapi;

import java.net.URI;

import org.w3c.dom.Document;

import com.agilex.vamf.metrics.clientapi.AuthenticationInfo;
import com.agilex.vamf.metrics.clientapi.JerseyClientHandle;
import com.agilex.vamf.metrics.clientapi.MobileHealthClientTestVersion;
import com.sun.jersey.api.client.WebResource;

public class MobileHealthClientTestVersion {
	private static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MobileHealthClientTestVersion.class);
	private JerseyClientHandle jerseyHandle = null;

	public MobileHealthClientTestVersion(URI uri, AuthenticationInfo authenticationInfo) {
		jerseyHandle = new JerseyClientHandle(uri, authenticationInfo);
	}

	public MobileHealthClientTestVersion(String uri, AuthenticationInfo authenticationInfo) {
		jerseyHandle = new JerseyClientHandle(uri, authenticationInfo);
	}

	public JerseyClientHandle getJerseyClientHandle() {
		return jerseyHandle;
	}

	public com.sun.jersey.api.client.Client getJerseyClient() {
		return getJerseyClientHandle().getJerseyClient();
	}

	public Document getAsXml(URI uri) {
		if (uri == null)
			throw new IllegalArgumentException();
		return getAsXml(uri.toString());
	}

	public Document getAsXml(String uri) {
		if (uri == null)
			throw new IllegalArgumentException();
		WebResource resource = jerseyHandle.resource(uri);
		logger.debug("GET " + uri.toString());
		Document result = resource.get(Document.class);
		return result;
	}

}
