package com.agilex.vamf.metrics.clientapi;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.vamf.metrics.clientapi.AuthenticationInfo;
import com.agilex.vamf.metrics.clientapi.MobileHealthClient;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.HTTPDigestAuthFilter;

public class MobileHealthClient extends Client {
	private static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MobileHealthClient.class);
	private URI mhpUri;
	private AuthenticationInfo authenticationInfo;

	public MobileHealthClient(URI uri, AuthenticationInfo authenticationInfo) {
		this.mhpUri = uri;
		this.authenticationInfo = authenticationInfo;
		initializeSecurity();
	}

	public MobileHealthClient(String uri, AuthenticationInfo authenticationInfo) {
		this.mhpUri = UriBuilder.fromPath(uri).build();
		this.authenticationInfo = authenticationInfo;
		initializeSecurity();
	}

	private void initializeSecurity() {
		if (this.authenticationInfo != null) {
			ClientFilter authFilter = null;
			String username = authenticationInfo.getUsername();
			String password = authenticationInfo.getPassword();

			if (authenticationInfo.getAuthtype().toUpperCase().contentEquals(AuthenticationInfo.BASIC_AUTHENTICATION)) {
				logger.debug(String.format("creating basic auth filter [%s][%s]", username, password));
				authFilter = new HTTPBasicAuthFilter(username, password);
			}
			if (authenticationInfo.getAuthtype().toUpperCase().contentEquals(AuthenticationInfo.DIGEST_AUTHENTICATION)) {
				logger.debug(String.format("creating digest auth filter [%s][%s]", username, password));
				authFilter = new HTTPDigestAuthFilter(username, password);
			}

			if (authFilter == null)
				throw new RuntimeException("Invalid authentication type " + authenticationInfo.getAuthtype());

			this.addFilter(authFilter);
		}
	}

	public WebResource resource() {
		return super.resource(mhpUri);
	}

	public WebResource patientsResource() {
		return resource().path("patients");
	}
}
