package com.agilex.vamf.metrics.domain;

import java.util.Date;
import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.mobilehealthplatform.domain.Namespace;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlRootElement(namespace = Namespace.MobileHealthPlatform, name = "userLogonsAudit")
@XmlAccessorType(value = XmlAccessType.NONE)
public class UserLoginAudit extends DomainTransferObject {
	
	private static final long serialVersionUID = 7348014852708535581L;

	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date loginDate;
	@XmlElement
	private String userId;
	@XmlElement
	private String accessToken;
	@XmlElement
	private String appName;

	public Date getLoginDate() {
		return loginDate;
	}

	public void setLoginDate(Date loginDate) {
		this.loginDate = loginDate;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getAccessToken() {
		return accessToken;
	}

	public void setAccessToken(String accessToken) {
		this.accessToken = accessToken;
	}

	public String getAppName() {
		return appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}
	
}
