package com.agilex.vamf.metrics.domain;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.mobilehealthplatform.domain.Namespace;
import com.agilex.healthcare.utility.DateHelper;

@XmlRootElement(namespace = Namespace.MobileHealthPlatform, name = "tag")
@XmlAccessorType(value = XmlAccessType.NONE)
public class ServiceTimingDetail implements Serializable {

	private static final long serialVersionUID = 5112067221875888924L;
	@XmlElement
	private String key=null;
	@XmlElement
	private String value=null;

	public ServiceTimingDetail() {
	}

	public ServiceTimingDetail(String key, String value) {
		this.key = key;
		this.value = value;
	}

	public ServiceTimingDetail(String key, long value) {
		this.key = key;
		this.value = Long.toString(value);
	}

	public ServiceTimingDetail(String key, Date value) {
		this.key = key;
		this.value = DateHelper.formatDateTime(value);
	}

	public ServiceTimingDetail(String tag) {
		this.key = tag;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getKey() {
		return key;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getValue() {
		return value;
	}
}
