package com.agilex.vamf.metrics.domain;

import java.io.Serializable;
import java.net.URI;
import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import com.agilex.healthcare.mobilehealthplatform.domain.Namespace;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlRootElement(namespace = Namespace.MobileHealthPlatform, name = "serviceTiming")
@XmlAccessorType(value = XmlAccessType.NONE)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ServiceTiming implements Serializable {
		
	private static final long serialVersionUID = -5734247976017884427L;
	
	@XmlElement
	protected String id;
	@XmlElement
	protected String parentId;
	@XmlElement
	protected long startTicks;
	@XmlElement
	protected long endTicks;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	protected Date startDate;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	protected Date endDate;
	@XmlElement
	protected String event;
	@XmlElement
	protected long timing;
	@XmlElement
	protected String userId;
	@XmlElement
	protected String accessToken;
	@XmlElement
	protected String appName;
	
	@XmlElement(name = "tag")
	protected ServiceTimingDetails tags = new ServiceTimingDetails();

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getParentId() {
		return parentId;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	public String getEvent() {
		return event;
	}

	public void setEvent(String event) {
		this.event = event;
	}

	public ServiceTimingDetails getTags() {
		return tags;
	}

	public void setTags(ServiceTimingDetails tags) {
		this.tags = tags;
	}

	public void appendTag(String key, int value) {
		appendTag(key, Integer.toString(value));
	}

	public void appendTag(String key, Date value) {
		appendTag(key, DateHelper.formatDate(value));
	}

	public void appendTag(String key, String value) {
		tags.add(new ServiceTimingDetail(key, value));
	}

	public void appendTag(String tag) {
		tags.add(new ServiceTimingDetail(tag));
	}

	public void appendTag(String tag, URI uri) {
		appendTag(tag + "-path", uri.toString());
		if (uri.getQuery() != null)
			appendTag(tag + "-qs", uri.getQuery());
	}

	public long getTiming() {

		if (this.timing != 0)
			return this.timing;
		else if (NullChecker.isNotNullish(endTicks)
				&& NullChecker.isNotNullish(startTicks))
			return (endTicks - startTicks);
		else if (NullChecker.isNotNullish(startDate)
				&& NullChecker.isNotNullish(endDate))
			return DateHelper.calculateDeltaInMillis(startDate, endDate);
		else
			return 0;
	}

	public void setTiming(long timing) {
		this.timing = timing;
	}

	public long getStartTicks() {
		return startTicks;
	}

	public void setStartTicks(long startTicks) {
		this.startTicks = startTicks;
	}

	public long getEndTicks() {
		return endTicks;
	}

	public void setEndTicks(long endTicks) {
		this.endTicks = endTicks;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getAccessToken() {
		return accessToken;
	}

	public void setAccessToken(String accessToken) {
		this.accessToken = accessToken;
	}

	public String getAppName() {
		return appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}

//	@Override
//	@XmlElement(name = "object-type")
//	@JsonProperty("object-type")
//	public String getObjectType() {
//		// TODO Auto-generated method stub
//		return this.getClass().getSimpleName();
//	}
	
}
