package com.agilex.vamf.metrics.domain;

import java.util.Date;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.mobilehealthplatform.domain.Namespace;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlRootElement(namespace = Namespace.MobileHealthPlatform, name = "clientAcct")
@XmlAccessorType(value = XmlAccessType.NONE)
public class ClientAccount extends DomainTransferObject {
	
	private static final long serialVersionUID = 6232762544632265638L;
	
	@XmlElement
	private String clientId;
	@XmlElement
	private String secret;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date expiredDate;

	
	public String getClientId() {
		return clientId;
	}
	public void setClientId(String id) {
		this.clientId = id;
	}
	public String getSecret() {
		return secret;
	}
	public void setSecret(String password) {
		this.secret = password;
	}
	public Date getExpiredDate() {
		return expiredDate;
	}
	public void setExpiredDate(Date expiredDate) {
		this.expiredDate = expiredDate;
	}

}
