package com.agilex.vamf.metrics;

import java.io.Serializable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.agilex.vamf.message.MessagePublisher;
import com.agilex.vamf.message.exception.MessagePublishException;
import com.agilex.vamf.metrics.exception.MetricsPublishException;

public class MetricMessagePublisher extends MessagePublisher implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 4327174344990395047L;
    
    protected final static Log logger = LogFactory.getLog(MetricMessagePublisher.class);


    public MetricMessagePublisher(MessageConfiguration configuration){
        super(configuration);
    }
    
    public void publishMessage(MetricMessage message) throws MetricsPublishException{
        try {
            super.publishMessage(message);
        } catch (MessagePublishException e) {
            throw new MetricsPublishException("Error Publishing Message ", e);
        }
    }

    @Override
    public void destroy() throws Exception {
        super.destroy();
    }
}
