package com.agilex.vamf.metrics.utility;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.apache.commons.codec.binary.Hex;

public class Hasher {
	private MessageDigest sha1HashAlgorithm = null;
	private Hex hexEncoder = null;

	public Hasher() {
		try {
			sha1HashAlgorithm = MessageDigest.getInstance("SHA-512");
			hexEncoder = new Hex();
		} catch (NoSuchAlgorithmException e) {
			throw new RuntimeException("Failed to hash to string", e);
		}

	}

	public String hashStringToString(String input) {
		String result;
		try {
			sha1HashAlgorithm.reset();
			byte[] byteResult = sha1HashAlgorithm.digest(input.getBytes("iso-8859-1"));
			byte[] hexarray = hexEncoder.encode(byteResult);
			result = new String(hexarray);
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException("Failed to convert hash to string", e);
		}
		return result;
	}
}
