package com.agilex.vamf.metrics.serializer;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;

import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;

@Provider
public class JSONJAXBContextResolver implements ContextResolver<JAXBContext> {

	private JAXBContext context;
	private String contextPath = "com.agilex.healthcare.mobilehealthplatform.domain:com.agilex.vamf.metrics.domain";

	public JSONJAXBContextResolver() throws Exception {
		JSONConfiguration.NaturalBuilder naturalBuilder = JSONConfiguration.natural();
		this.context = new JSONJAXBContext(naturalBuilder.build(), contextPath);
	}

	@Override
	public JAXBContext getContext(Class<?> objectType) {
		return context;
	}
}