package com.agilex.vamf.metrics.restservice;

import java.util.List;
import java.util.Set;

import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.utility.DateHelper;
import com.agilex.vamf.metrics.Timing;
import com.agilex.vamf.metrics.domain.ServiceTiming;

@Path("/audit")
@Service
public class AuditResource {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(AuditResource.class);

	@Resource
	Timing timing;
	
	@POST
	@Consumes({ "application/xml", "application/json" })
	public void recordAudit(ServiceTiming t, @Context UriInfo u, @Context HttpHeaders headers) {
		logger.debug("capture timing remote event");
		if (t.getAccessToken() == null) {
			setAccessToken(headers, t);	
		}
		
		timing.logEvent(t);
	}

	private void setAccessToken(HttpHeaders headers, ServiceTiming t) {
		Set<String> headerKeys = headers.getRequestHeaders().keySet();
		for (String k : headerKeys) {
			List<String> valueList = headers.getRequestHeader(k);
			for (String value : valueList) {
				t.appendTag("http-header." + k, value);
				if ("authorization".equalsIgnoreCase(k)) {
					t.setAccessToken(stripChars(value, "Bearer "));
					break;
				}
			}
		}
	}

	private String stripChars(String input, String strip) {
	    StringBuilder result = new StringBuilder();
	    for (char c : input.toCharArray()) {
	        if (strip.indexOf(c) == -1) {
	            result.append(c);
	        }
	    }
	    return result.toString();
	}
	
	@GET
	@Path("/sample")
	@Produces({ "application/xml", "application/json" })
	public ServiceTiming getAudit(@Context UriInfo u, @Context HttpHeaders headers) {
		ServiceTiming t = new ServiceTiming();
		t.setEvent("sample event");
		t.appendTag("tag", "value");
		t.appendTag("tag2", "value2");
		t.setStartDate(DateHelper.parseDate("1/1/2001"));
		t.setEndDate(DateHelper.parseDate("1/1/2011"));
		t.setStartTicks(10000000);
		t.setEndTicks(10100000);
		t.setUserId("D123401");
		t.setAccessToken(headers.getRequestHeader("authorization").get(0));
		t.setAppName("AppointmentService");
		t.appendTag("k", "v");
		t.appendTag("kn", 1);
		t.appendTag("tt");
		return t;
	}
}
