package com.agilex.vamf.metrics.restservice;

import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.stereotype.Service;

import com.agilex.vamf.metrics.Timing;
import com.agilex.vamf.metrics.domain.ServiceTiming;

@Path("/audit-basic")
@Service
public class AuditHybridAppResource {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(AuditHybridAppResource.class);
	
	@Resource
	Timing timing;

	@POST
	@Consumes({ "application/xml", "application/json" })
	public void saveMetric(ServiceTiming serviceTimingAudit, 
							@Context UriInfo u,
							@Context HttpHeaders headers) {
		logger.debug("save metric");
		timing.logEvent(serviceTimingAudit);
	}
	
}
