package com.agilex.vamf.metrics.datalayer;

import javax.persistence.EntityManager;

@SuppressWarnings("unchecked")
public class ValidPo<T extends PersistenceObject> {
	private boolean ok = true;
	private T po = null;

	public ValidPo(EntityManager entityManager, T obj) {
		if (isNewRecord(obj)) {
			po = null;
			ok = true;
		} else {
			po = (T) entityManager.find(obj.getClass(), obj.getId());
			if (null != po) {
			    ok = computeOk(po, obj);    
			}
		}
	}

	public boolean isOk() {
		return ok;
	}

	public T getPo() {
		return po;
	}

	private boolean computeOk(T po, T obj) {
		try {
			return po.getUserId().equalsIgnoreCase(obj.getUserId());
		} catch (NullPointerException e) {
			return true;
		}
	}

	private boolean isNewRecord(T obj) {
		return obj.getId() == null;
	}
}