package com.agilex.vamf.metrics.datalayer;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.vamf.metrics.domain.UserLoginAudit;

@Entity
@Table(name = "USER_LOGIN_MV")
public class UserLoginAuditPo extends PersistenceObject implements Transformable<UserLoginAudit> {

	private static final long serialVersionUID = -223138814263364463L;
	@Id
	@Column(name="LOGIN_DATETIME")
	private Date loginDate;
	@Column(name="USER_ID")
	private String userId;
	@Column(name="ACCESS_TOKEN")
	private String accessToken;
	@Column(name="APP_NAME")
	private String appName;
	
	public UserLoginAuditPo(){
	}

	@Override
	public UserLoginAudit create() {
		UserLoginAudit dto = new UserLoginAudit();
		dto.setLoginDate(getLoginDate());
		dto.setUserId(getUserId());
		dto.setAccessToken(getAccessToken());
		dto.setAppName(getAppName());
		
		return dto;
	}	
	
	public Date getLoginDate() {
		return loginDate;
	}

	public void setLoginDate(Date startDate) {
		this.loginDate = startDate;
	}
	
	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}
	
	public String getAccessToken() {
		return accessToken;
	}

	public void setAccessToken(String accessToken) {
		this.accessToken = accessToken;
	}
	
	public String getAppName() {
		return appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}
	
}