package com.agilex.vamf.metrics.datalayer;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.agilex.vamf.metrics.domain.ServiceTiming;
import com.agilex.vamf.metrics.domain.ServiceTimingDetail;

@Entity
@Table(name = "METRIC")
public class MetricPo extends PersistenceObject implements Transformable<ServiceTiming> {
	
	private static final long serialVersionUID = 7556034154606647975L;
	
	private String metricName;
	private Long timing;
	private String parentEventId;
	private Date startDate;
	private Date endDate;
	private Long startTicks;
	private Long endTicks;
	private String result;
	private String userId;
	private String accessToken;
	private String appName;
	private List<MetricDataPo> metricData = new ArrayList<MetricDataPo>();
	
	public MetricPo(){
	}

	public MetricPo(ServiceTiming timing){

		setMetricName(timing.getEvent());
		setTiming(timing.getTiming());
		setParentEventId(timing.getParentId());
		setStartDate(timing.getStartDate());
		setEndDate(timing.getEndDate());
		setStartTicks(timing.getStartTicks());
		setEndTicks(timing.getEndTicks());
		setUserId(timing.getUserId());
		setAccessToken(timing.getAccessToken());
		setAppName(timing.getAppName());
				
		for (ServiceTimingDetail keyValuePair : timing.getTags()) {
			metricData.add(new MetricDataPo(keyValuePair));
			if ("status".equalsIgnoreCase(keyValuePair.getKey())) {
				setResult(keyValuePair.getValue());
			}
		}
		
	}
	
	@Override
	public ServiceTiming create() {
		ServiceTiming dto = new ServiceTiming();
		
		dto.setId(getId());
		dto.setEvent(getMetricName());
		dto.setTiming(getTiming());
		dto.setParentId(getParentEventId());
		dto.setStartDate(getStartDate());
		dto.setEndDate(getEndDate());
		dto.setStartTicks(getStartTicks());
		dto.setEndTicks(getEndTicks());
		dto.setUserId(getUserId());
		dto.setAccessToken(getAccessToken());
		dto.setAppName(getAppName());
		
		for (MetricDataPo metricData : getMetricData()) {
			dto.appendTag(metricData.getTag(), metricData.getValue());
		}
		
		return dto;
	}	
	
    @Id
    @GeneratedValue(generator="metric_id_generator")
    @GenericGenerator(name="metric_id_generator", strategy = "uuid")
    @Column(name="ID", nullable=false)	
	public String getId() {
		return super.getId();
	}

    @Column(name="METRIC_NAME", nullable=false)
    public String getMetricName() {
    	return metricName;
    }

	public void setMetricName(String metricName) {
		this.metricName = metricName;
	}

	@Column(name="TIMING")
	public Long getTiming() {
		return timing;
	}

	public void setTiming(Long timing) {
		this.timing = timing;
	}

	@Column(name="PARENT_EVENT_ID")
	public String getParentEventId() {
		return parentEventId;
	}

	public void setParentEventId(String parentEventId) {
		this.parentEventId = parentEventId;
	}

	@Column(name="START_DATE", nullable=false)
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	@Column(name="END_DATE")
	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	@Column(name="START_TICKS")
	public Long getStartTicks() {
		return startTicks;
	}

	public void setStartTicks(Long startTicks) {
		this.startTicks = startTicks;
	}

	@Column(name="END_TICKS")
	public Long getEndTicks() {
		return endTicks;
	}

	public void setEndTicks(Long endTicks) {
		this.endTicks = endTicks;
	}

	@Column(name="RESULT_STATUS")
	public String getResult() {
		return result;
	}

	public void setResult(String result) {
		this.result = result;
	}

	@Column(name="USER_ID")
	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	@Column(name="ACCESS_TOKEN")
	public String getAccessToken() {
		return accessToken;
	}

	public void setAccessToken(String accessToken) {
		this.accessToken = accessToken;
	}

	@Column(name="APP_NAME")
	public String getAppName() {
		return appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}
	
	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
	@JoinColumn(name="METRIC_ID", referencedColumnName="ID", nullable=false, updatable=false)
	public List<MetricDataPo> getMetricData() {
		return metricData;
	}

	public void setMetricData(List<MetricDataPo> metricData) {
		this.metricData = metricData;
	}
	
}