package com.agilex.vamf.metrics.datalayer;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import com.agilex.vamf.metrics.MetricThreadPoolListener;
import com.agilex.vamf.metrics.domain.ServiceTiming;

public class MetricDataService {
	
    @Resource
    private MetricDataLayer metricDataLayer;

    public void saveTimingMetric(ServiceTiming timing) {
        if (timing.getUserId() == null) {
            appendUserTags(timing);
        }
        saveMetric(timing);
    }

    private void saveMetric(final ServiceTiming timing) {
        MetricThreadPoolListener.execute(new Runnable() {

            @Override
            public void run() {
                metricDataLayer.saveTimingMetric(timing);
            }
        });
    }

    private void appendUserTags(ServiceTiming timing) {
        MhpUser currentUser = getCurrentUser();
        String userId = currentUser == null ? "anonymous" : currentUser.getUserIdentifier().toString();
        timing.appendTag("logged-in-user-id", userId);
        if (currentUser != null) {
            timing.setUserId(currentUser.getUserIdentifier().toString());
        } else {
            timing.setUserId(userId);
        }
    }

    private MhpUser getCurrentUser() {
        return MhpUserFactory.createFromSecurityContext();
    }
}

