package com.agilex.vamf.metrics.datalayer;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.agilex.vamf.metrics.domain.ServiceTimingDetail;

@Entity
@Table(name = "METRIC_DATA")
public class MetricDataPo extends PersistenceObject implements Transformable<ServiceTimingDetail> {

	private static final long serialVersionUID = -6787632516182566014L;
	
	private String tag;
	private String value;
	
	public MetricDataPo() {}

	public MetricDataPo(ServiceTimingDetail pair) {
		setTag(pair.getKey());
		setValue(pair.getValue());
	}
	
	@Override
	public ServiceTimingDetail create() {
		return new ServiceTimingDetail(getTag(), getValue());
	}
	
    @Id
    @GeneratedValue(generator="metric_data_id_generator")
    @GenericGenerator(name="metric_data_id_generator", strategy = "uuid")
    @Column(name="ID", nullable=false)	
	public String getId() {
		return super.getId();
	}	

	@Column(name="TAG", nullable=false)
	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}
	
	@Column(name="VALUE")
	public String getValue() {
		return value;
	}
	
	public void setValue(String value) {
		this.value = value;
	}

}

