package com.agilex.vamf.metrics.datalayer;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.utility.NullChecker;
import com.agilex.vamf.metrics.domain.ServiceTiming;
import com.agilex.vamf.metrics.domain.ClientAccount;
import com.agilex.vamf.metrics.domain.UserLoginAudits;

@Service
public class MetricDataLayerRepo implements MetricDataLayer {

	@Resource
	MetricDao metricDao;
	
	public MetricDataLayerRepo(){}
	
	@Override
	public UserLoginAudits fetchUserLoginAudits() {
	    return createUserLogonsAudits(this.metricDao.fetchUserLoginAudits());
	}
	
	private UserLoginAudits createUserLogonsAudits(List<UserLoginAuditPo> userLoginAuditPos) {
	    UserLoginAudits userLogonsAudits = new UserLoginAudits();
            if (NullChecker.isNotNullish(userLoginAuditPos)) {
                for(UserLoginAuditPo po : userLoginAuditPos) {
                	userLogonsAudits.add(po.create());
                }
            }
            return userLogonsAudits;
        }

	@Override
	public void saveTimingMetric(ServiceTiming timing) {
	    if (null != timing.getUserId() && !"anonymous".equalsIgnoreCase(timing.getUserId()) && null != timing.getAccessToken()) {
	        List<MetricPo> metricPos = fetchMetricsByLoginAppNameAndUserId("login", timing.getUserId(), timing.getAccessToken());
	        if (null != metricPos && metricPos.size() > 0) {
	            MetricPo metricPo = getLatestMetricPo(metricPos, timing.getAccessToken());
	            if (null != metricPo && null == metricPo.getAccessToken()) {
	                metricPo.setId(null);
	                metricPo.setAccessToken(timing.getAccessToken());
	                metricDao.save(metricPo);
	            }
	        }
	    }
            MetricPo po = new MetricPo(timing);
            metricDao.save(po);
	}
	
	private MetricPo getLatestMetricPo(List<MetricPo> metricPos, String accessToken) {
	    MetricPo newMetricPo = null;
	    for (MetricPo metricPo : metricPos) {
	        if (null != metricPo.getAccessToken() && accessToken.equalsIgnoreCase(metricPo.getAccessToken())) {
	            return null;
	        }
                if (newMetricPo == null || metricPo.getEndDate().compareTo(newMetricPo.getEndDate()) > 0){
                    newMetricPo = metricPo;
                }  
            }
            return newMetricPo;
        }

	@Override
	public ClientAccount fetchClientAccount(String userId) {
	    ClientAccountPo po = metricDao.fetchClientAccount(userId);
	    return po.create();
	}

        @Override
        public List<MetricPo> fetchMetricsByLoginAppNameAndUserId(String appName, String userId, String accessToken) {
            if (checkLoginMetricWithAccessToken(appName, userId, accessToken)) {
               return null; 
            }
            List<MetricPo> metricPos = this.metricDao.fetchMetricsByLoginAppNameAndUserId(appName, userId);
            return metricPos;
        }

        private boolean checkLoginMetricWithAccessToken(String appName, String userId, String accessToken) {
            List<MetricPo> metricPos = this.metricDao.fetchMetricsByLoginAppNameAndUserIdAndAccessToken(appName, userId, accessToken);
            if (metricPos != null && metricPos.size() > 0) {
                return true;
            }
            return false;
        }
}
