package com.agilex.vamf.metrics.datalayer;

import java.util.List;

import javax.persistence.TypedQuery;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class MetricDao extends MetricAbstractDao {


        private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MetricDao.class);
	
	private static final String WHERE_LOGIN_APP_NAME = "from MetricPo where appName = :appName and userId = :userId and accessToken is null";
	private static final String WHERE_LOGIN_APP_NAME_WITH_ACCESS_TOKEN = "from MetricPo where appName = :appName and userId = :userId and accessToken = :accessToken";
	
	public MetricDao(){}
	
	public List<UserLoginAuditPo> fetchUserLoginAudits(){
		final TypedQuery<UserLoginAuditPo> query = this.entityManager.createQuery("from UserLoginAuditPo", UserLoginAuditPo.class);
		List<UserLoginAuditPo> results = query.getResultList();
		return results;
	}
		
	@Transactional("metricTransactionManager")
	public void save(MetricPo metric) {
		if (logger.isDebugEnabled()) {
			logger.debug("saving timing metric");
		}
		SimpleEntityManager<MetricPo> simpleEntityManager = new SimpleEntityManager<MetricPo>(entityManager);
		MetricPo metricPo = simpleEntityManager.save(metric);
		if (logger.isDebugEnabled()) {
			logger.debug("saved timing metric with id " + metricPo.getId());
		}

	}	

        public List<MetricPo> fetchMetricsByLoginAppNameAndUserId(String appName, String userId){
            final TypedQuery<MetricPo> query = this.entityManager.createQuery(WHERE_LOGIN_APP_NAME, MetricPo.class);
            query.setParameter("appName", appName);
            query.setParameter("userId", userId);
            List<MetricPo> result = query.getResultList();
            return result;
        }

        public List<MetricPo> fetchMetricsByLoginAppNameAndUserIdAndAccessToken(String appName, String userId, String accessToken){
            final TypedQuery<MetricPo> query = this.entityManager.createQuery(WHERE_LOGIN_APP_NAME_WITH_ACCESS_TOKEN, MetricPo.class);
            query.setParameter("appName", appName);
            query.setParameter("userId", userId);
            query.setParameter("accessToken", accessToken);
            List<MetricPo> result = query.getResultList();
            return result;
        }
        
	public ClientAccountPo fetchClientAccount(String clientId) {
		final TypedQuery<ClientAccountPo> query = this.entityManager.createQuery("from ClientAccountPo where clientId = :clientId", ClientAccountPo.class);
		query.setParameter("clientId", clientId);
		List<ClientAccountPo> results = query.getResultList();
		ClientAccountPo po = null;
		if (results != null && results.size() > 0){
			po = results.get(0);
		}
		return po;
	}
}
