package com.agilex.vamf.metrics.datalayer;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import com.agilex.vamf.metrics.domain.ClientAccount;

@Entity
@Table(name = "CLIENT_ACCOUNT")
public class ClientAccountPo extends PersistenceObject implements Transformable<ClientAccount> {
		
	private static final long serialVersionUID = 183967191539624179L;
    @Id
    @Column(name="CLIENT_ID", nullable=false)	
	private String clientId;
    
    @Column(name="SECRET", nullable=false)
	private String secret;
    
    @Column(name="EXPIRED_DATE")
	private Date expiredDate;
	
	public ClientAccountPo(){}

	public ClientAccountPo(ClientAccount userAcct){
		this.setUserId(userAcct.getClientId());
		this.setSecret(userAcct.getSecret());
		this.setExpiredDate(userAcct.getExpiredDate());
	}
	@Override
	public ClientAccount create() {
		ClientAccount account = new ClientAccount();
		account.setClientId(this.getUserId());
		account.setSecret(this.getSecret());
		account.setExpiredDate(this.getExpiredDate());
		return account;
	}
	
	@Override
	public String getUserId() {
		return clientId;
	}
	@Override
	public void setUserId(String userId) {
		this.clientId = userId;
	}

	public String getSecret() {
		return secret;
	}

	public void setSecret(String secret) {
		this.secret = secret;
	}

	public Date getExpiredDate() {
		return expiredDate;
	}

	public void setExpiredDate(Date expiredDate) {
		this.expiredDate = expiredDate;
	}
	
}