package com.agilex.vamf.metrics.auth.provider;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

import com.agilex.vamf.metrics.datalayer.MetricDataLayer;
import com.agilex.vamf.metrics.domain.ClientAccount;

public class MetricUserDetailsService implements UserDetailsService{
	
	@Resource
	private MetricDataLayer metricDataLayer;

	private static boolean accountIsEnabled = true;
	private static boolean accountNonExpired = true;
	private static boolean credentialsNonExpired = true;
	private static boolean accountNonLocked = true;

	@Override
	public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, CredentialsExpiredException {
		ClientAccount userFound = metricDataLayer.fetchClientAccount(username);
		List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
		authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
		if (userFound==null) {
			throw new UsernameNotFoundException("Invalid clientId");
		} else if (userFound.getExpiredDate() != null){
			throw new CredentialsExpiredException("Account is expired");
		}
		
		UserDetails user = new User(username, userFound.getSecret(), accountIsEnabled, credentialsNonExpired, accountNonLocked, accountNonExpired, authorities);
		return user;
	}
	
}

