package com.agilex.vamf.metrics;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.agilex.messaging.core.MessageHandler;
import com.agilex.vamf.metrics.datalayer.MetricDataService;
import com.agilex.vamf.metrics.domain.ServiceTiming;

public class MetricMessageHandler implements MessageHandler<MetricMessage> {
    private final Log logger = LogFactory.getLog(MetricMessageHandler.class);

    @Resource
    private MetricDataService metricDataService;
    
    public MetricMessageHandler(){}
    
    @Override
    public void handle(MetricMessage metricMessage) {
        
        logger.debug("Handle message: " + metricMessage.getClass().getName() + "; id: " + metricMessage.id());
        metricDataService.saveTimingMetric((ServiceTiming)metricMessage.getMessageObject());
        
    }

}
