package com.agilex.vamf.metrics.datalayer;

import java.util.List;

import javax.annotation.Resource;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.utility.DateHelper;
import com.agilex.vamf.metrics.datalayer.MetricDataLayerRepo;
import com.agilex.vamf.metrics.domain.ServiceTiming;
import com.agilex.vamf.metrics.domain.UserLoginAudits;

public class MetricDataLayerTest extends MetricSpringContextConfig {

    @Resource
    MetricDataLayerRepo metricDataLayer;
    
    @Before
    public void saveTimingMetric() {
    	ServiceTiming timing = new ServiceTiming();
    	timing.setStartDate(DateHelper.parseDateTime("3/1/2014 01:02:03"));
		timing.setEndDate(DateHelper.parseDateTime("3/1/2014 01:02:05"));
		timing.setUserId("dfn-777#1");
		timing.setAccessToken("Bearer 1");
		timing.setAppName("login");
		timing.setEvent("test metric name");
		timing.appendTag("Version", "APP 0.1.0");
		timing.appendTag("c", "MetricDataLayerTest");
		timing.appendTag("m", "saveTimingMetric");
		timing.appendTag("status", "Success");	
		metricDataLayer.saveTimingMetric(timing);
    }
    
    @Test
    public void fetchUserLoginAudits() {
        Assert.assertNotNull(metricDataLayer);
        UserLoginAudits userLogonsAudits = metricDataLayer.fetchUserLoginAudits();
        Assert.assertNotNull(userLogonsAudits);
        Assert.assertTrue(userLogonsAudits.size()>0);
    }

    @Test
    public void fetchMetricsByLoginAppNameAndUserId() {
        Assert.assertNotNull(metricDataLayer);
        List<MetricPo> metricPos = metricDataLayer.fetchMetricsByLoginAppNameAndUserId("login", "dfn-777#1", "Bearer 1");
        Assert.assertNull(metricPos);
        //Assert.assertTrue(metricPos.size()>0);
    }
    
}
