package com.agilex.vamf.metrics;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import com.agilex.vamf.metrics.datalayer.MetricSpringContextConfig;
import com.agilex.vamf.metrics.domain.ServiceTimingDetail;
import com.agilex.vamf.metrics.enumeration.ClosingStatus;
import com.agilex.vamf.metrics.utility.Hasher;

public class TimingTest extends MetricSpringContextConfig {
    
    @Autowired 
    Timing timing;
    @Autowired 
    Timing firstTiming;
    @Autowired 
    Timing secondTiming;
    @Autowired 
    Timing thirdTiming;
    @Autowired 
    Timing myEventTiming;
    
    @Before
    public void setup() {
       
    }

    @After
    public void tearDown(){
    }
	
	//@Ignore
        @Test
	public void timingTest() throws InterruptedException {
		//Timing timing = Timing.getInstance("doStuff");
		Thread.sleep(1000);

//		Timing secondTiming = Timing.getInstance("second thing");
		Thread.sleep(1000);
		secondTiming.markComplete(ClosingStatus.Success);
		Thread.sleep(1000);
//		Timing thirdTiming = Timing.getInstance("third thing");
		Thread.sleep(1000);
//		Timing.getInstance("forth thing");
		Thread.sleep(1000);
		thirdTiming.markComplete(ClosingStatus.Success);
		thirdTiming.appendTag("mykey");
		Thread.sleep(1000);
		firstTiming.markComplete(ClosingStatus.Success);
	}

	//@Ignore
        @Test
	public void sensitiveDataRemovedFromTags() {
		String nonSensitiveValue = "okay";
		String sensitiveValue = "sensitive";
		myEventTiming.setEnableHashSensitiveData(true);
		String hashedSensitiveValue = (new Hasher()).hashStringToString(sensitiveValue);

		//Timing timing = Timing.getInstance("myEvent");
		myEventTiming.appendTag("mykey");
		myEventTiming.appendTag("mykey2", nonSensitiveValue);
		myEventTiming.appendTag("uri", sensitiveValue);
		myEventTiming.appendTag("URI", sensitiveValue);
		myEventTiming.appendTag("request-path", sensitiveValue);
		myEventTiming.appendTag("request-qs", sensitiveValue);
		myEventTiming.markComplete(ClosingStatus.Success);

		assertValueOfTag(myEventTiming, "mykey", null);
		assertValueOfTag(myEventTiming, "mykey2", nonSensitiveValue);
		assertValueOfTag(myEventTiming, "uri", hashedSensitiveValue);
		assertValueOfTag(myEventTiming, "URI", hashedSensitiveValue);
		assertValueOfTag(myEventTiming, "request-path", hashedSensitiveValue);
		assertValueOfTag(myEventTiming, "request-qs", hashedSensitiveValue);
	}

	private void assertValueOfTag(Timing t, String key, String expectedValue) {
		boolean found = false;
		for (ServiceTimingDetail tag : t.getTags()) {
			if (tag.getKey().contentEquals(key)) {
				found = true;
				assertEquals(expectedValue, tag.getValue());
				System.out.println(String.format("%s=>%s", tag.getKey(), tag.getValue()));
			}
		}
		assertTrue(String.format("Tag %s not found", key), found);
	}

}
