package com.agilex.vamf.metrics;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import com.agilex.healthcare.utility.DateHelper;
import com.agilex.vamf.metrics.datalayer.MetricSpringContextConfig;
import com.agilex.vamf.metrics.domain.ServiceTiming;
import com.agilex.vamf.metrics.exception.MetricsPublishException;

public class MetricMessagePublisherTest extends MetricSpringContextConfig {

    @Autowired
    private MetricMessagePublisher publisher;

    @Before
    public void setup() {
       
    }

    @After
    public void tearDown(){
    }

    @Test
    public void sendMessage() throws MetricsPublishException {
        ServiceTiming timing = new ServiceTiming();
        timing.setStartDate(DateHelper.parseDateTime("3/1/2014 01:02:03"));
        timing.setEndDate(DateHelper.parseDateTime("3/1/2014 01:02:05"));
        timing.setUserId("dfn-777#1");
        timing.setAccessToken("Bearer 1");
        timing.setAppName("Appointment");
        timing.setEvent("test metric name");
        timing.appendTag("Version", "APP 0.1.0");
        timing.appendTag("c", "MetricDataLayerTest");
        timing.appendTag("m", "saveTimingMetric");
        timing.appendTag("status", "Success");  
        MetricMessage message = new MetricMessage(timing);
        publisher.publishMessage(message);
    }



}
